;; This example shows how to read a file byte by byte.
;;
;; A file without a header must be read this way, it can't be
;; read using CAS IN DIRECT (unless the in-memory header is patched)
;;
;; This example doesn't have any error checking.

.cas_in_open equ &bc77
.cas_in_close equ &bc7a
.cas_in_char equ &bc80

ld hl,&4000					;; address to load file data to (example)
push hl

;; open file for reading
ld b,end_filename-filename
ld hl,filename
ld de,two_k_buffer
call cas_in_open

;; If a file is opened without a header:
;; - the filetype will be ASCII (&16)
;; - the length and load address will be undefined.
;;
;; If a file is opened with a header, the 
;; - the filetype will be taken from the header
;; - the length and load address will be taken from the header
;;
;; A file without a header can't be read with CAS IN DIRECT
;; and must be read using CAS IN CHAR.

pop hl

;; read a char from the file, character is returned in A register
.next_byte
call cas_in_char
jr nc,not_eof
jr nz,not_eof

;; could be end of file
;; test for hard end of file byte
cp &f
jr nz,not_eof
jr eof

.not_eof
;; write byte to memory
ld (hl),a
inc hl
jr next_byte

.eof
call cas_in_close
ret

;;-------------------------------------------------------------------
;; name of the file to read

.filename
defb "datafile.bin"
.end_filename

;;-------------------------------------------------------------------
;; this buffer is filled with data from the file
.two_k_buffer defs 2048